<?php
// Caminho do arquivo onde o comando foi salvo
$commandFilePath = __DIR__ . '/command.txt';

// Verifica se o arquivo de comando existe
if (file_exists($commandFilePath)) {
    // Lê o conteúdo do arquivo JSON
    $commandJson = file_get_contents($commandFilePath);

    // Converte o conteúdo JSON para um array PHP
    $commandData = json_decode($commandJson, true);

    // Verifica se o comando e o nome do pacote estão presentes
    if (isset($commandData['command']) && isset($commandData['packageName'])) {
        $command = $commandData['command'];
        $packageName = $commandData['packageName'];

        // Exemplo: Comando de desinstalação
        if ($command === 'uninstall') {
            // Aqui você pode enviar o comando para o dispositivo (via API, servidor, etc.)
            // Para fins de exemplo, apenas exibimos o comando
            echo "Comando de desinstalação para o pacote: $packageName";
            
            // Em um cenário real, você pode fazer algo como chamar uma API do dispositivo,
            // ou iniciar uma requisição de desinstalação, conforme necessário.
        }
    } else {
        echo "Erro: Comando ou pacote não encontrado no arquivo.";
    }

    // Opcional: Apaga o arquivo após o comando ser processado
    unlink($commandFilePath);

} else {
    echo "Erro: Arquivo de comando não encontrado.";
}
?>
